<?php
require_once 'config.php';
require_once 'header.php';

// أيقونات التصنيفات حسب الاسم
$categoryIcons = [
    'facebook' => 'bi-facebook',
    'instagram' => 'bi-instagram',
    'tiktok' => 'bi-tiktok',
    'youtube' => 'bi-youtube',
    'telegram' => 'bi-telegram',
    'twitter' => 'bi-twitter',
    'spotify' => 'bi-spotify',
    'reports' => 'bi-flag',
    'canva' => 'bi-palette',
    'other' => 'bi-box',
];

// دالة توحيد اسم التصنيف
function normalizeCategory($cat) {
    $cat = strtolower(trim($cat));
    if (strpos($cat, 'facebook') !== false) return 'facebook';
    if (strpos($cat, 'instagram') !== false) return 'instagram';
    if (strpos($cat, 'tiktok') !== false) return 'tiktok';
    if (strpos($cat, 'youtube') !== false) return 'youtube';
    if (strpos($cat, 'telegram') !== false) return 'telegram';
    if (strpos($cat, 'twitter') !== false) return 'twitter';
    if (strpos($cat, 'spotify') !== false) return 'spotify';
    if (strpos($cat, 'report') !== false) return 'reports';
    if (strpos($cat, 'canva') !== false) return 'canva';
    return $cat ?: 'other';
}

// جلب الخدمات مباشرة بدون التصنيفات
$query = "SELECT * FROM services ORDER BY id ASC";
$result = $conn->query($query);
if (!$result) {
    die("Error fetching services: " . $conn->error);
}
$services = [];
while ($row = $result->fetch_assoc()) {
    // أضف التصنيف الموحد لكل خدمة
    $row['normalized_category'] = normalizeCategory($row['category']);
    $services[] = $row;
}

// تجميع التصنيفات من الخدمات
$categories = [];
foreach ($services as $service) {
    $normCat = $service['normalized_category'];
    if (!isset($categories[$normCat])) {
        $icon = $categoryIcons[$normCat] ?? 'bi-box';
        $categories[$normCat] = [
            'id' => $normCat,
            'name' => ucfirst($normCat),
            'icon' => $icon
        ];
    }
}
$categories = array_values($categories);
?>

<style>
/* تحسينات عامة */
.service-card {
    transition: transform 0.2s, box-shadow 0.2s;
}
.service-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.3) !important;
}
.card {
    border: none;
    background: rgba(255,255,255,0.05);
    backdrop-filter: blur(10px);
}
.card-body {
    padding: 1.5rem;
}
.text-gradient {
    background: linear-gradient(90deg, #e14eca 0%, #7367f0 100%);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

/* تحسينات الديسكتوب */
@media (min-width: 577px) {
    .categories-row {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        gap: 12px;
        width: 90%;
        margin: 0 auto 25px auto;
    }
    .category-btn {
        min-width: 180px;
        height: 48px;
        font-size: 1.1rem;
        border-radius: 12px !important;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
        padding: 0 15px !important;
        margin: 0 !important;
        background: rgba(255,255,255,0.05);
        border: 1px solid rgba(255,255,255,0.1);
        transition: all 0.3s ease;
    }
    .category-btn:hover, .category-btn.active {
        background: rgba(255,255,255,0.1);
        border-color: #e14eca;
        transform: translateY(-2px);
    }
    .category-btn .cat-text {
        display: inline;
    }
    .category-details {
        display: none !important;
    }
    .category-search {
        width: 400px;
        margin: 0 auto 30px auto;
        display: block;
        font-size: 1.1rem;
        padding: 12px 20px;
        border-radius: 12px;
        background: rgba(255,255,255,0.05);
        border: 1px solid rgba(255,255,255,0.1);
        color: #fff;
    }
    .category-search:focus {
        background: rgba(255,255,255,0.08);
        border-color: #e14eca;
        box-shadow: 0 0 0 0.2rem rgba(225,78,202,0.25);
    }
    .row#services-list {
        justify-content: center;
        gap: 20px;
    }
    .service-card {
        flex: 0 0 calc(33.333% - 20px);
        max-width: calc(33.333% - 20px);
    }
}

/* تحسينات الموبايل */
@media (max-width: 576px) {
    .categories-row {
        display: grid;
        grid-template-columns: repeat(4, 1fr);
        gap: 10px;
        width: 95%;
        margin: 0 auto 15px auto;
        padding-bottom: 8px;
        direction: rtl;
    }
    .category-btn {
        width: 45px;
        height: 45px;
        font-size: 0.9rem;
        margin: 0 !important;
        padding: 0 !important;
        border-radius: 10px !important;
        display: flex;
        align-items: center;
        justify-content: center;
        background: rgba(255,255,255,0.05);
        border: 1px solid rgba(255,255,255,0.1);
    }
    .category-btn.active {
        background: rgba(255,255,255,0.1);
        border-color: #e14eca;
    }
    .category-btn .cat-text {
        display: none;
    }
    .category-details {
        background: rgba(255,255,255,0.05);
        color: #fff;
        border-radius: 10px;
        margin: 0 auto 15px auto;
        padding: 10px;
        width: 90%;
        font-size: 0.95rem;
        text-align: center;
        border: 1px solid rgba(255,255,255,0.1);
    }
    .service-card {
        margin-bottom: 15px;
    }
    .card-body {
        padding: 1.2rem;
    }
}

/* تحسينات المودال */
.modal-content {
    background: rgba(35,38,58,0.95);
    backdrop-filter: blur(10px);
    border: 1px solid rgba(255,255,255,0.1);
}
.modal-header {
    border-bottom: 1px solid rgba(255,255,255,0.1);
}
.modal-body {
    padding: 1.5rem;
}
.modal-title {
    font-size: 1.3rem;
    font-weight: 600;
}
</style>

<div class="container py-5">
    <h1 class="text-center fw-bold mb-2" style="font-size:2.2rem;">خدماتنا</h1>
    <div class="text-center mb-4">
        <span class="badge bg-primary fs-5" style="background: linear-gradient(90deg, #e14eca 0%, #7367f0 100%); color: #fff; padding: 10px 24px; border-radius: 16px;">
            عدد الخدمات: <?= count($services) ?>
        </span>
    </div>
    
    <!-- مربع البحث -->
    <input type="text" class="category-search" id="categorySearch" placeholder="ابحث عن خدمة أو تصنيف...">
    
    <!-- أزرار التصنيفات -->
    <div class="categories-row" id="categories-row">
        <?php foreach ($categories as $cat): ?>
            <button class="btn btn-outline-light category-btn" data-category="<?= $cat['id'] ?>">
                <i class="bi <?= $cat['icon'] ?>"></i>
                <span class="cat-text"><?= $cat['name'] ?></span>
            </button>
        <?php endforeach; ?>
    </div>
    
    <!-- تفاصيل التصنيف -->
    <div id="category-details-container"></div>
    
    <!-- كروت الخدمات -->
    <div class="row" id="services-list">
        <?php foreach ($services as $srv): ?>
            <div class="col-md-6 col-lg-4 mb-4 service-card" data-category="<?= $srv['normalized_category'] ?>">
                <div class="card h-100">
                    <div class="card-body">
                        <div class="d-flex align-items-center justify-content-between mb-3">
                            <?php $icon = $categoryIcons[$srv['normalized_category']] ?? 'bi-box'; ?>
                            <span class="fs-4"><i class="bi <?= $icon ?>"></i></span>
                            <span class="fw-bold fs-5"><?= htmlspecialchars($srv['title'] ?? $srv['name']) ?></span>
                        </div>
                        
                        <p class="text-secondary mb-3" style="min-height:48px;"><?= htmlspecialchars($srv['description']) ?></p>
                        
                        <ul class="list-unstyled mb-3 text-end">
                            <?php 
                            if (!empty($srv['features'])) {
                                $features = is_string($srv['features']) ? json_decode($srv['features'], true) : $srv['features'];
                                if ($features && is_array($features)) {
                                    foreach ($features as $feature): 
                            ?>
                                <li class="mb-2">
                                    <i class="bi bi-check-circle-fill text-success ms-1"></i>
                                    <?= htmlspecialchars($feature) ?>
                                </li>
                            <?php 
                                    endforeach;
                                }
                            }
                            ?>
                        </ul>
                        
                        <div class="d-flex align-items-center justify-content-between mt-3">
                            <span class="fw-bold fs-5 text-gradient"><?= $srv['price'] ?></span>
                            <button class="btn btn-primary btn-sm px-3 view-details-btn" data-id="<?= $srv['id'] ?>">
                                عرض الخدمة
                            </button>
                        </div>
                        
                        <?php if (!empty($srv['popular'])): ?>
                            <span class="badge position-absolute top-0 start-0 m-2 text-gradient" style="background: <?= $srv['gradient'] ?? 'linear-gradient(90deg, #e14eca 0%, #7367f0 100%)' ?>; color:#fff;">
                                الأكثر طلباً
                            </span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<!-- نافذة تفاصيل الخدمة -->
<div class="modal fade" id="serviceDetailsModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title fw-bold" id="serviceModalTitle"></h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="إغلاق"></button>
            </div>
            <div class="modal-body">
                <div id="serviceModalDesc" class="mb-4"></div>
                <ul id="serviceModalFeatures" class="list-unstyled mb-4"></ul>
                <div class="d-flex align-items-center justify-content-between">
                    <span class="fw-bold fs-5 text-gradient" id="serviceModalPrice"></span>
                    <button class="btn btn-primary">طلب الخدمة</button>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// تصفية الخدمات حسب التصنيف
const categoryBtns = document.querySelectorAll('.category-btn');
const serviceCards = document.querySelectorAll('.service-card');

categoryBtns.forEach(btn => {
    btn.addEventListener('click', function() {
        categoryBtns.forEach(b => b.classList.remove('active'));
        this.classList.add('active');
        const cat = this.getAttribute('data-category');
        
        serviceCards.forEach(card => {
            if (cat === 'all' || card.getAttribute('data-category') === cat) {
                card.style.display = '';
            } else {
                card.style.display = 'none';
            }
        });
    });
});

// عرض تفاصيل الخدمة في المودال
const servicesData = <?php echo json_encode($services, JSON_UNESCAPED_UNICODE); ?>;
document.querySelectorAll('.view-details-btn').forEach(btn => {
    btn.addEventListener('click', function() {
        const id = this.getAttribute('data-id');
        const srv = servicesData.find(s => s.id == id);
        if (!srv) return;

        // تحديث عنوان الخدمة
        document.getElementById('serviceModalTitle').textContent = srv.title || srv.name;

        // تحديث وصف الخدمة
        document.getElementById('serviceModalDesc').textContent = srv.description;

        // تحديث السعر
        if (srv.price !== undefined && srv.price !== null && srv.price !== '') {
            document.getElementById('serviceModalPrice').innerHTML = `<strong>${srv.price}</strong>`;
        } else {
            document.getElementById('serviceModalPrice').innerHTML = '<span class="text-danger">لم يتم تحديد سعر لهذه الخدمة</span>';
        }

        // تحديث المميزات
        const featuresList = document.getElementById('serviceModalFeatures');
        featuresList.innerHTML = '';
        
        if (srv.features) {
            const features = typeof srv.features === 'string' ? JSON.parse(srv.features) : srv.features;
            if (Array.isArray(features)) {
                features.forEach(f => {
                    const li = document.createElement('li');
                    li.className = 'mb-2';
                    li.innerHTML = `<i class="bi bi-check-circle-fill text-success ms-1"></i>${f}`;
                    featuresList.appendChild(li);
                });
            }
        }

        // تحديث زر طلب الخدمة
        const orderBtn = document.createElement('a');
        orderBtn.className = 'btn btn-primary';
        orderBtn.textContent = 'طلب الخدمة';
        orderBtn.href = `order-service.php?service_id=${srv.id}`;
        const modalFooter = document.querySelector('#serviceDetailsModal .modal-body .btn.btn-primary');
        if (modalFooter) modalFooter.replaceWith(orderBtn);

        // عرض المودال
        const modal = new bootstrap.Modal(document.getElementById('serviceDetailsModal'));
        modal.show();
    });
});

// تفاصيل التصنيف في الموبايل
const categoriesData = <?php echo json_encode($categories, JSON_UNESCAPED_UNICODE); ?>;
if(window.innerWidth <= 576) {
    document.querySelectorAll('.category-btn').forEach(btn => {
        btn.addEventListener('click', function(e) {
            e.preventDefault();
            document.querySelectorAll('.category-details').forEach(d => d.remove());
            document.querySelectorAll('.category-btn').forEach(b => b.classList.remove('active'));
            this.classList.add('active');
            
            const catId = this.getAttribute('data-category');
            const catObj = categoriesData.find(c => c.id === catId);
            if (catObj) {
                const detailsDiv = document.createElement('div');
                detailsDiv.className = 'category-details';
                detailsDiv.innerHTML = `<div class='cat-title'>${catObj.name}</div>`;
                document.getElementById('category-details-container').appendChild(detailsDiv);
            }
        });
    });
}

// البحث
document.getElementById('categorySearch').addEventListener('input', function() {
    const val = this.value.trim().toLowerCase();
    document.querySelectorAll('.category-btn').forEach(btn => {
        const text = btn.querySelector('.cat-text').textContent.toLowerCase();
        if (text.includes(val) || val === '') {
            btn.style.display = '';
        } else {
            btn.style.display = 'none';
        }
        btn.classList.remove('active');
    });
    document.getElementById('category-details-container').innerHTML = '';
});
</script>

<?php require_once 'footer.php'; ?>